<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'dob', 'password', 'stripe_id', 'phone_number', 'profile_pic', 'initial_status');

    public function roles()
    {
        return $this->hasOne('App\Models\Role', 'role_id');
    }

    public function medicalHistories()
    {
        return $this->hasMany('App\Models\MedicalHistory', 'id');
    }

    public function payments()
    {
        return $this->hasMany('App\Models\Payment', 'id');
    }

    public function doctor_infos()
    {
        return $this->hasOne('App\Models\User', 'doctor_id');
    }

}